/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.item;

import com.badlogic.gdx.utils.IntMap;
import java.util.List;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.item.ItemEntityAssetsByAssetType;
import technology.rocketjump.undermount.assets.entities.item.model.ItemEntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;

public class ItemEntityAssetsByQuantity {
    private IntMap<ItemEntityAssetsByAssetType> quantityMap = new IntMap();
    private static final int MIN_QUANTITY = 0;
    private static final int MAX_QUANTITY = 32;

    public ItemEntityAssetsByQuantity(EntityAssetTypeDictionary entityAssetTypeDictionary, ItemTypeDictionary itemTypeDictionary) {
        for (int q = 0; q <= 32; ++q) {
            this.quantityMap.put(q, new ItemEntityAssetsByAssetType(entityAssetTypeDictionary, itemTypeDictionary));
        }
    }

    public void add(ItemEntityAsset asset) {
        for (int cursor = asset.getMinQuantity(); cursor <= asset.getMaxQuantity(); ++cursor) {
            this.quantityMap.get(cursor).add(asset);
        }
    }

    public ItemEntityAsset get(EntityAssetType assetType, ItemEntityAttributes attributes) {
        return this.quantityMap.get(attributes.getQuantity()).get(assetType, attributes);
    }

    public List<ItemEntityAsset> getAll(EntityAssetType assetType, ItemEntityAttributes attributes) {
        return this.quantityMap.get(attributes.getQuantity()).getAll(assetType, attributes);
    }
}

